
/*============================================================================
 Name        : command_fun.h
 Author      :
 Date  	     : 2015.9
 Copyright   : ZKSoftware Inc.
 Description : Linux C
 ============================================================================*/
#ifndef		_COMMAND_FUN_H_
#define		_COMMAND_FUN_H_

//#include <platform.h>
#include <sys/select.h>
#include <sys/time.h>
#include <dlfcn.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <curses.h>


#ifndef GCC_PACKED
#define GCC_PACKED		__attribute__((packed))
#endif

/******************************** Serial initialization ******************************/
int INIT(char *dev);
int DisplayFail(int Flag);
int ParameterSelect(int flag);

unsigned long pd_get_ticks(void);
void pd_msleep(int ms);

int DebugFile_init(void);
/******************************** window ************************************/
int CursesInit(void);
void WinBox(void);
void CloseWin(void);
void DebugWin(WINDOW *win1, int num);
/******************************** data check ************************************/
char MHeader_chksum(unsigned char*p);
int MData_chksum(unsigned char*p, int len);

/**************************** Receive and send instructions *************************/
typedef int (* Send_command_fun)(int, int, int, unsigned char *, int);
typedef int (* Recv_Command_fun)(int, int *, int *, unsigned char *, int *, unsigned long);
typedef int (* Recv_Command_usb_fun)(int, int *, int *, unsigned char *, int *, unsigned long);
typedef int (* extSend_command_fun)(int, int, short, short, unsigned char *, int);
typedef int (* extRecv_Command_fun)(int, int *, short *, short *, unsigned char *, int *, unsigned long);
typedef int (* extRecv_Command_usb_fun)(int, int *, short *, short *, unsigned char *, int *, unsigned long);
typedef struct
{
	Send_command_fun SendCmd;
	Recv_Command_fun RecvCmd;
	Recv_Command_usb_fun RecvCmd_usb;
	extSend_command_fun extSendCmd;
	extRecv_Command_fun extRecvCmd;
	extRecv_Command_usb_fun extRecvCmd_usb;
}Command_fun;
extern Command_fun Cmd;

INT RecvExtDataPro(INT Command, U32 timeout);
INT SendExtDataPro(INT Command, INT *Param, INT *flag, U32 timeout, U8 *buf, INT size);
INT Recv_data(VOID);
INT RecvData_Check(INT recvSize, INT *dataSize, ePRSHeader pHeader, U8 *DataRecvBuff);
/**************************** time check *********************************/
int timeCheck(int Year, int Month, int Day, int Hour, int Minute, int Second);

typedef struct _Image_
{
	int width;
	int height;
	int compressed;
	int encrypted;
	int binary;
	int img_len;
	int template_len;
} TImage, *PImage;

typedef struct _ExtDataBuf_
{
	U8 *buffer;
	U8 *bufPtr;
	U8 *bufEnd;
	int bufferSize;
	int Index;
	int PacketNum;
	int PacketLen;
}TExtDataBuf,*PExtDataBuf;

extern TExtDataBuf ExtDataBuffer;
extern U8 *DATABUFF;
extern U8 *DATA_pro;
extern U8 *DATA_end;
extern FILE *Fp;
extern INT SetTime_loop;
extern INT Err_flag;
extern VOID *sensor;
extern INT Dev_num;
/********************* curses ***********************/
extern WINDOW *win, *win1, *win2;
#define WIN_COL		85
#define WIN_LINE	25

/*****************************************************/
#pragma pack(1)

typedef struct tagBITMAPFILEHEADER {
	U16 bfType;
	U32 bfSize;
	U16 bfReserved1;
	U16 bfReserved2;
	U32 bfOffBits;
} BITMAPFILEHEADER, *LPBITMAPFILEHEADER, *PBITMAPFILEHEADER;

typedef struct tagBITMAPINFOHEADER {
	U32 biSize;
	S32 biWidth;
	S32 biHeight;
	U16 biPlanes;
	U16 biBitCount;
	U32 biCompression;
	U32 biSizeImage;
	S32 biXPelsPerMeter;
	S32 biYPelsPerMeter;
	U32 biClrUsed;
	U32 biClrImportant;
} BITMAPINFOHEADER, *LPBITMAPINFOHEADER, *PBITMAPINFOHEADER;

typedef struct tagRGBQUAD {
	U8 rgbBlue;
	U8 rgbGreen;
	U8 rgbRed;
	U8 rgbReserved;
} RGBQUAD;

typedef struct tagBITMAPINFO {
	BITMAPINFOHEADER bmiHeader;
	RGBQUAD bmiColors[1];
} BITMAPINFO, *LPBITMAPINFO, *PBITMAPINFO;

#pragma pack()

#endif
